/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	RadialDimension.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CDrawing.h"
#include "CApplication.h"


HRESULT RadialDimension(IDesign *pDesign, IDrawingDocument *pDrawingDoc, IGraphic *pGraph1, IRadialDimLine **radialdim)
{
	//	Creates a Radial Dimension
	START_METHOD("RadialDimension")

	HRESULT status = CONV_SUCCESS;

	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IDrawingDocOthers *doc1 = CAST(IDrawingDocOthers, pDrawingDoc);

	IDrawingDocument *activeDoc = CAST(IDrawingDocument, pDrawingDoc);

	IGraphicDocument *activeGraphicDoc = CAST(IGraphicDocument, activeDoc);

	IDrawing *localDraw = NULL;
	status = activeDoc->GetDrawing(&localDraw);
	CHECK_RETURN_STATUS(status)
	
	IDesignDetail *pDetail = NULL;
	status = localDraw->GetDetail(pDesign, FALSE,&pDetail);
	CHECK_RETURN_STATUS(status)
	
	IGeometry *pGeom1 = NULL;
	status = activeDoc->GetPaperGeometry(pGraph1, &pGeom1);
	CHECK_RETURN_STATUS(status)
	
	IGeometry *pOriginal = NULL;
	status = pGeom1->GetOriginal(&pOriginal);
	CHECK_RETURN_STATUS(status)
	
	IDesignInstance *pView1 = NULL;
	status = pGeom1->GetInstance(&pView1);
	CHECK_RETURN_STATUS(status)
	
	IDimension *pDimension = NULL;
	status = (GetCLASS(Dimension))->CreateDimension(pDetail, 2, pOriginal, &pDimension);
	CHECK_RETURN_STATUS(status)
	
	IVector *pPosition= NULL;
	status = (GetCLASS(Vector))->CreateVector(0.001, 0.001, 0, &pPosition);
	CHECK_RETURN_STATUS(status)
	
	IRadialDimLine *pRadialDim = NULL;
	status = (GetCLASS(RadialDimLine))->CreateRadialDimLine(pPosition, pDimension, CAST(IHiddenLine, pView1), &pRadialDim);
	CHECK_RETURN_STATUS(status)
	
	IDimLine *localDimLine = CAST(IDimLine, pRadialDim);
	
	IVector *pDimLinepos = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.1, 0.1, 0, &pDimLinepos);
	CHECK_RETURN_STATUS(status)
	
	status = localDimLine->SetPosition(pDimLinepos);
	CHECK_RETURN_STATUS(status)
	

	IDimTol *pTolerance = NULL;
	status = (GetCLASS(DimTol))->CreateDimTol(pDetail, pDimension, &pTolerance);
	CHECK_RETURN_STATUS(status)

	IDimensionCallout *pCallout = NULL;
	
	status = (GetCLASS(DimensionCallout))->CreateDimensionCallout(pTolerance, &pCallout);
	CHECK_RETURN_STATUS(status)
	
	IDimLineText *pText = NULL;
	status = (GetCLASS(DimLineText))->CreateDimLineText(CAST(IDimLine, pRadialDim), CAST(ICallout, pCallout), pPosition, 0.0035, &pText);
	CHECK_RETURN_STATUS(status)
	
	ICalloutGroup *localCalloutGroup = CAST(ICalloutGroup, pText);
	
	status = localCalloutGroup->SetControlPoint(1,pPosition);
	CHECK_RETURN_STATUS(status)

	// Get the active sheet in current drawing
	ISheet *pSheet = NULL;
	status = pDrawingDoc->GetActiveSheet(&pSheet);
	CHECK_RETURN_STATUS(status)

	status = pSheet->AddDimLine(CAST(IDimLine, pRadialDim));
	CHECK_RETURN_STATUS(status)

	
	// Add center line
	// To be done
	
	*radialdim = pRadialDim;
	
	END_METHOD("RadialDimension")
}
